/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.domain;

import com.ibm.hsc.ccfw.pa.system.PICecFsp;
import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.fw.domain.Domain;
import com.ibm.hwmca.fw.domain.DomainIdentifier;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.pa.util.LockAcquisitionException;
import com.ibm.hwmca.fw.pa.util.LockHeldException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.domain.RioTopologyReader;
import com.ibm.hwmca.p.pa.event.RioDomainAnalysisEvent;
import com.ibm.hwmca.xfw.pa.domain.DistributedAnalysisDomain;
import com.ibm.hwmca.xfw.pa.event.AnalysisDomainAnalysisEvent;
import com.ibm.hwmca.xfw.pa.system.RemoteMachineSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RioAnalysisDomain
extends DistributedAnalysisDomain {
    private static final String TRACE_MASKT = "PPARIADT";
    private static final String TRACE_MASKF = "PPARIADF";
    private static final String TRACE_MASKD = "PPARIADD";

    public RioAnalysisDomain() {
        Trace.trace((String)TRACE_MASKD, (Object)"<-> ctor");
    }

    public RioAnalysisDomain(DomainIdentifier domainIdentifier) {
        super(domainIdentifier);
    }

    protected Set instantiateDomains() {
        Trace.trace((String)TRACE_MASKD, (Object)"--> instantiateDomains");
        this.realInstanceSet = new HashSet();
        try {
            this.realInstanceSet = this.getDomainSet();
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKD, (Object)exception);
        }
        super.instantiateDomains();
        Trace.trace((String)TRACE_MASKD, (Object)"<-- instantiateDomains");
        return this.realInstanceSet;
    }

    public DistributedAnalysisDomain getDomain(String string) {
        return null;
    }

    private Set getDomainSet() throws Exception {
        RioAnalysisDomain rioAnalysisDomain;
        HashSet<RioAnalysisDomain> hashSet = new HashSet<RioAnalysisDomain>();
        String[] stringArray = RioTopologyReader.getRioDomainIds();
        for (int i = 0; i < stringArray.length; ++i) {
            rioAnalysisDomain = (RioAnalysisDomain)((Object)((Object)((Object)this)).getClass().newInstance());
            rioAnalysisDomain.setDomainId(new DomainIdentifier(stringArray[i]));
            HashSet<List> hashSet2 = new HashSet<List>();
            hashSet2.add(RioTopologyReader.getCecsOnLoop((String)stringArray[i]));
            rioAnalysisDomain.setMonitoredRemoteMachineSystems(hashSet2);
            hashSet.add(rioAnalysisDomain);
            Trace.trace((String)TRACE_MASKF, (Object)("build a domain for " + stringArray[i]));
        }
        if (stringArray.length == 0) {
            Trace.trace((String)TRACE_MASKF, (Object)"got no domains back from the RIO topology");
        }
        RioAnalysisDomain rioAnalysisDomain2 = (RioAnalysisDomain)((Object)((Object)((Object)this)).getClass().newInstance());
        rioAnalysisDomain = HMC.getHMC();
        rioAnalysisDomain2.setDomainId(new DomainIdentifier("RIO DEFAULT" + rioAnalysisDomain.getMachineModel() + rioAnalysisDomain.getMachineType() + rioAnalysisDomain.getMachineSerial()));
        hashSet.add(rioAnalysisDomain2);
        Trace.trace((String)TRACE_MASKF, (Object)"add a default RIO loop");
        return hashSet;
    }

    private List getRioLoopsForSystem(RemoteMachineSystem remoteMachineSystem) {
        ArrayList<String> arrayList = Collections.EMPTY_LIST;
        arrayList = new ArrayList<String>(16);
        for (int i = 0; i < 16; ++i) {
            arrayList.add(Integer.toString(i + 1668));
        }
        return arrayList;
    }

    protected void remoteMachineAdd(RemoteMachineSystem remoteMachineSystem) {
        Trace.trace((String)TRACE_MASKF, (Object)"-->remoteMachineAdd()");
        if (remoteMachineSystem instanceof PICecFsp) {
            try {
                Set set = this.getDomainSet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    RioAnalysisDomain rioAnalysisDomain = (RioAnalysisDomain)((Object)iterator.next());
                    this.builderSetup(rioAnalysisDomain);
                    rioAnalysisDomain.initialize();
                }
                this.realInstanceSet.clear();
                this.realInstanceSet.add(set);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKT, (Object)"Exception caught building domain");
                Trace.trace((String)TRACE_MASKT, (Object)exception);
            }
        }
        Trace.trace((String)TRACE_MASKF, (Object)"<-- remoteMachineAdd()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteMachineRemove(RemoteMachineSystem remoteMachineSystem) {
        if (remoteMachineSystem instanceof PICecFsp) {
            Set set = this.realInstanceSet;
            synchronized (set) {
                Iterator iterator = this.realInstanceSet.iterator();
                RioAnalysisDomain rioAnalysisDomain = null;
                while (iterator.hasNext()) {
                    rioAnalysisDomain = (RioAnalysisDomain)((Object)iterator.next());
                    if (!rioAnalysisDomain.getDomainId().getDID().startsWith(remoteMachineSystem.getSystemName())) continue;
                    Trace.trace((String)TRACE_MASKD, (Object)("removing domain instance [" + rioAnalysisDomain.getDomainId().getDID() + "]"));
                    iterator.remove();
                    rioAnalysisDomain.remove();
                }
            }
        }
    }

    public PASystem getPrimary() {
        ConsoleAnalysisDomain consoleAnalysisDomain = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
        if (consoleAnalysisDomain == null) {
            return null;
        }
        return consoleAnalysisDomain.getConsoleSystem();
    }

    protected boolean synchronizeDuringInitialization() {
        return false;
    }

    public void beginPrimaryArbitration() {
    }

    protected boolean isPrimaryAcceptible() {
        return true;
    }

    protected void acquireArbitrationLock() throws LockAcquisitionException, LockHeldException {
    }

    protected void releaseArbitrationLock() throws LockAcquisitionException {
    }

    protected PASystem getArbitrationLockHolder() throws LockAcquisitionException {
        return this.getPrimary();
    }

    public AnalysisDomainAnalysisEvent getSystemAnalysisEvent(Object object) {
        return new RioDomainAnalysisEvent(object);
    }

    public boolean isPrimary() {
        Trace.trace((String)TRACE_MASKF, (Object)"--> isPrimary()");
        boolean bl = true;
        List list = RioTopologyReader.getCecsOnLoop((String)this.getDomainId().getDID());
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = RioAnalysisDomain.getMachineName((String)iterator.next());
                Trace.trace((String)TRACE_MASKF, (Object)("the machine to look for is " + string));
                Domain domain = this.foundDomain(string);
                if (domain == null || !(domain instanceof DistributedAnalysisDomain)) continue;
                Trace.trace((String)TRACE_MASKF, (Object)"found the cec domain. Return it's value");
                bl = ((DistributedAnalysisDomain)domain).isPrimary();
            }
        }
        Trace.trace((String)TRACE_MASKF, (Object)("<-- isPrimary(" + bl + ")"));
        return bl;
    }

    public static String getMachineName(String string) {
        String string2 = string.replace('-', '/');
        string2 = string.replace('*', '-');
        return string2;
    }

    private Domain foundDomain(String string) {
        Domain domain = null;
        domain = DomainManager.getDomainManager().get(new DomainIdentifier(string));
        return domain;
    }
}

